<?php
require_once 'config.php';
require_once 'redsysAPI.php';

$importe = $_GET['importe'] ?? '1000'; // en céntimos
$pedido = $_GET['pedido'] ?? time();
$concepto = $_GET['concepto'] ?? 'Pago prueba';

$redsys = new RedsysAPI;
$redsys->setParameter("DS_MERCHANT_AMOUNT", $importe);
$redsys->setParameter("DS_MERCHANT_ORDER", str_pad($pedido, 12, "0", STR_PAD_LEFT));
$redsys->setParameter("DS_MERCHANT_MERCHANTCODE", REDSYS_FUC);
$redsys->setParameter("DS_MERCHANT_CURRENCY", REDSYS_CURRENCY);
$redsys->setParameter("DS_MERCHANT_TRANSACTIONTYPE", "0");
$redsys->setParameter("DS_MERCHANT_TERMINAL", REDSYS_TERMINAL);
$redsys->setParameter("DS_MERCHANT_URLOK", REDSYS_URL_OK);
$redsys->setParameter("DS_MERCHANT_URLKO", REDSYS_URL_KO);
$redsys->setParameter("DS_MERCHANT_PRODUCTDESCRIPTION", $concepto);

$params = $redsys->createMerchantParameters();
$signature = $redsys->createMerchantSignature(REDSYS_SECRET);
?>
<form id="redsysForm" action="<?= REDSYS_URL ?>" method="POST">
  <input type="hidden" name="Ds_SignatureVersion" value="HMAC_SHA256_V1">
  <input type="hidden" name="Ds_MerchantParameters" value="<?= $params ?>">
  <input type="hidden" name="Ds_Signature" value="<?= $signature ?>">
</form>
<script>document.getElementById('redsysForm').submit();</script>
